<?php
date_default_timezone_set('America/Mexico_City');
$hoy = date('Y-m-d');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Solicitud Creativa</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script>
        function validarFechas() {
            const fPeticion = document.getElementById("fecha_peticion").value;
            const fEntrega = document.getElementById("fecha_entrega").value;
            const hoy = new Date().toISOString().split('T')[0];

            if (fPeticion < hoy) {
                alert("La fecha de petición no puede ser menor a hoy.");
                return false;
            }
            if (fEntrega < fPeticion) {
                alert("La fecha de entrega no puede ser menor a la de petición.");
                return false;
            }
            return true;
        }
    </script>
</head>
<body class="p-4">
    <div class="container">
        <h3>Solicitud Creativa</h3>
        <form action="guardar_solicitud.php" method="POST" onsubmit="return validarFechas();">
            <div class="mb-3">
                <label>Punto 1:</label>
                <input type="text" name="punto1" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Punto 2:</label>
                <input type="text" name="punto2" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Punto 3:</label>
                <input type="text" name="punto3" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Punto 4:</label>
                <input type="text" name="punto4" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Punto 5:</label>
                <input type="text" name="punto5" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Fecha de Petición:</label>
                <input type="date" id="fecha_peticion" name="fecha_peticion" class="form-control" min="<?= $hoy ?>" required>
            </div>
            <div class="mb-3">
                <label>Fecha de Entrega:</label>
                <input type="date" id="fecha_entrega" name="fecha_entrega" class="form-control" min="<?= $hoy ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">Enviar solicitud</button>
        </form>
    </div>
</body>
</html>
