<?php
require 'conexion.php';
$orden = isset($_GET['orden']) ? $_GET['orden'] : 'fecha_peticion';
$result = $conn->query("SELECT * FROM solicitudes ORDER BY $orden ASC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ver Solicitudes</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="p-3">
<div class="container">
    <h3>Solicitudes Recibidas</h3>
    <div class="mb-3">
        <a href="?orden=fecha_peticion" class="btn btn-secondary btn-sm">Ordenar por Fecha de Solicitud</a>
        <a href="?orden=fecha_entrega" class="btn btn-secondary btn-sm">Ordenar por Fecha de Entrega</a>
    </div>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th><th>Punto1</th><th>Petición</th><th>Entrega</th>
                <th>Estatus</th><th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $result->fetch_assoc()){ ?>
            <tr>
                <td><?= $row['id'] ?></td>
                <td><?= htmlspecialchars($row['punto1']) ?></td>
                <td><?= $row['fecha_peticion'] ?></td>
                <td><?= $row['fecha_entrega'] ?></td>
                <td>
                    <form action="actualizar_estatus.php" method="POST" style="display:inline;">
                        <input type="hidden" name="id" value="<?= $row['id'] ?>">
                        <select name="estatus" onchange="this.form.submit()" class="form-select form-select-sm">
                            <option <?= $row['estatus']=='En espera'?'selected':'' ?>>En espera</option>
                            <option <?= $row['estatus']=='Iniciado'?'selected':'' ?>>Iniciado</option>
                            <option <?= $row['estatus']=='Entregado'?'selected':'' ?>>Entregado</option>
                        </select>
                    </form>
                </td>
                <td>
                    <a href="previsualizar.php?id=<?= $row['id'] ?>" class="btn btn-info btn-sm">Ver</a>
                    <a href="imprimir_pdf.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm">Imprimir (Web)</a>
                    <a href="imprimir_pdf_fpdf.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">Imprimir (FPDF)</a>
                </td>
            </tr>
            <?php } ?>
        </tbody>
    </table>
</div>
</body>
</html>
